/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rooms.constructions;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.RandomXS128;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.crafting.CraftingRecipeDictionary;
import technology.rocketjump.undermount.entities.behaviour.furniture.CraftingStationBehaviour;
import technology.rocketjump.undermount.entities.behaviour.furniture.FurnitureBehaviour;
import technology.rocketjump.undermount.entities.components.DecorationInventoryComponent;
import technology.rocketjump.undermount.entities.factories.FurnitureEntityAttributesFactory;
import technology.rocketjump.undermount.entities.factories.FurnitureEntityFactory;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemTypeDictionary;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.jobs.model.CraftingType;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.messaging.types.DoorwayPlacementMessage;
import technology.rocketjump.undermount.messaging.types.EntityMessage;
import technology.rocketjump.undermount.messaging.types.FurniturePlacementMessage;
import technology.rocketjump.undermount.messaging.types.ItemCreationRequestMessage;
import technology.rocketjump.undermount.misc.VectorUtils;
import technology.rocketjump.undermount.rooms.ItemAllocation;
import technology.rocketjump.undermount.rooms.constructions.Construction;
import technology.rocketjump.undermount.rooms.constructions.ConstructionStore;
import technology.rocketjump.undermount.rooms.constructions.DoorwayConstruction;
import technology.rocketjump.undermount.rooms.constructions.FurnitureConstruction;
import technology.rocketjump.undermount.settlement.ItemTracker;

@Singleton
public class ConstructionMessageHandler
implements GameContextAware,
Telegraph {
    private final MessageDispatcher messageDispatcher;
    private final ConstructionStore constructionStore;
    private final ItemTypeDictionary itemTypeDictionary;
    private final CraftingRecipeDictionary craftingRecipeDictionary;
    private final ItemTracker itemTracker;
    private final FurnitureEntityAttributesFactory furnitureEntityAttributesFactory;
    private final FurnitureEntityFactory furnitureEntityFactory;
    private GameContext gameContext;
    private Entity callbackItem;

    @Inject
    public ConstructionMessageHandler(MessageDispatcher messageDispatcher, ConstructionStore constructionStore, ItemTypeDictionary itemTypeDictionary, CraftingRecipeDictionary craftingRecipeDictionary, ItemTracker itemTracker, FurnitureEntityAttributesFactory furnitureEntityAttributesFactory, FurnitureEntityFactory furnitureEntityFactory) {
        this.messageDispatcher = messageDispatcher;
        this.constructionStore = constructionStore;
        this.itemTypeDictionary = itemTypeDictionary;
        this.craftingRecipeDictionary = craftingRecipeDictionary;
        this.itemTracker = itemTracker;
        this.furnitureEntityAttributesFactory = furnitureEntityAttributesFactory;
        this.furnitureEntityFactory = furnitureEntityFactory;
        messageDispatcher.addListener(this, 805);
        messageDispatcher.addListener(this, 806);
        messageDispatcher.addListener(this, 807);
        messageDispatcher.addListener(this, 701);
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case 805: {
                return this.handle((FurniturePlacementMessage)msg.extraInfo);
            }
            case 806: {
                return this.handle((DoorwayPlacementMessage)msg.extraInfo);
            }
            case 701: {
                ItemAllocation allocation = (ItemAllocation)msg.extraInfo;
                if (allocation.getTargetType().equals((Object)ItemAllocation.AllocationTargetType.CONSTRUCTION)) {
                    Entity itemEntity;
                    Construction targetConstruction = this.constructionStore.getById(allocation.getTargetId());
                    if (targetConstruction != null) {
                        targetConstruction.allocationCancelled(allocation);
                    }
                    if ((itemEntity = this.gameContext.getEntityStore().getById(allocation.getItemEntityId())) != null) {
                        ItemEntityAttributes attributes = (ItemEntityAttributes)itemEntity.getPhysicalEntityComponent().getAttributes();
                        attributes.setNumAllocated(attributes.getNumAllocated() - allocation.getQuantity());
                    }
                    return true;
                }
                return false;
            }
            case 807: {
                FurnitureConstruction completedConstruction = (FurnitureConstruction)msg.extraInfo;
                return this.handleConstructionCompleted(completedConstruction);
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }

    private boolean handle(FurniturePlacementMessage furniturePlacementMessage) {
        this.constructionStore.create(new FurnitureConstruction(furniturePlacementMessage.getFurnitureEntityToPlace().clone(this.messageDispatcher, this.gameContext.getAreaMap())));
        return true;
    }

    private boolean handle(DoorwayPlacementMessage placeDoorwayMessage) {
        FurnitureEntityAttributes attributes = this.furnitureEntityAttributesFactory.byName("SINGLE_DOOR_PLACEMENT", placeDoorwayMessage.getDoorwayMaterial());
        Entity placementDoorwayEntity = this.furnitureEntityFactory.create(attributes, placeDoorwayMessage.getTilePosition(), null, this.gameContext.getAreaMap());
        this.constructionStore.create(new DoorwayConstruction(placementDoorwayEntity, placeDoorwayMessage));
        return true;
    }

    private boolean handleConstructionCompleted(FurnitureConstruction construction) {
        List<ItemType> itemsForCraftingType;
        for (GridPoint2 tileLocation : construction.getTileLocations()) {
            MapTile tileAtLocation = this.gameContext.getAreaMap().getTile(tileLocation);
            for (Entity entity : tileAtLocation.getEntities()) {
                if (!entity.getType().equals((Object)EntityType.ITEM)) continue;
                this.messageDispatcher.dispatchMessage(0.01f, 322, (Object)new EntityMessage(entity.getId()));
            }
            tileAtLocation.setConstruction(null);
        }
        if (construction instanceof DoorwayConstruction) {
            DoorwayConstruction doorwayConstruction = (DoorwayConstruction)construction;
            this.messageDispatcher.dispatchMessage(801, doorwayConstruction.getPlaceDoorwayMessage());
            return true;
        }
        FurnitureEntityAttributes constructionAttributes = (FurnitureEntityAttributes)construction.getFurnitureEntityToBePlaced().getPhysicalEntityComponent().getAttributes();
        FurnitureEntityAttributes createdAttributes = this.furnitureEntityAttributesFactory.byType(constructionAttributes.getFurnitureType(), constructionAttributes.getMaterials().get((Object)constructionAttributes.getPrimaryMaterialType()));
        createdAttributes.setCurrentLayout(constructionAttributes.getCurrentLayout());
        Entity createdFurnitureEntity = this.furnitureEntityFactory.create(createdAttributes, construction.getPrimaryLocation(), new FurnitureBehaviour(), this.gameContext.getAreaMap());
        CraftingType craftingType = createdAttributes.getFurnitureType().getCraftingType();
        if (craftingType != null) {
            createdFurnitureEntity.setBehaviourComponent(new CraftingStationBehaviour(craftingType, this.craftingRecipeDictionary.getByCraftingType(craftingType), this.itemTracker));
        }
        createdFurnitureEntity.getBehaviourComponent().init(createdFurnitureEntity, this.messageDispatcher, this.gameContext.getAreaMap());
        LinkedList<GameMaterial> materialsToApply = new LinkedList<GameMaterial>();
        for (GameMaterialType gameMaterialType : createdAttributes.getMaterials().keySet()) {
            materialsToApply.add(this.findApplicableMaterial(construction, gameMaterialType));
        }
        for (GameMaterial gameMaterial : materialsToApply) {
            createdAttributes.getMaterials().put(gameMaterial.getMaterialType(), gameMaterial);
        }
        if (createdAttributes.getFurnitureType().getCraftingType() != null && (itemsForCraftingType = this.itemTypeDictionary.getByCraftingType(createdAttributes.getFurnitureType().getCraftingType())) != null && itemsForCraftingType.size() > 0) {
            Entity attachedItem2;
            Collections.shuffle(itemsForCraftingType, new RandomXS128(createdAttributes.getSeed()));
            DecorationInventoryComponent decorationInventoryComponent = new DecorationInventoryComponent();
            Entity attachedItem = this.createAttachedItem(itemsForCraftingType.get(0));
            if (attachedItem != null) {
                decorationInventoryComponent.add(attachedItem);
            }
            if (itemsForCraftingType.size() > 1 && (attachedItem2 = this.createAttachedItem(itemsForCraftingType.get(1))) != null) {
                decorationInventoryComponent.add(attachedItem2);
            }
            createdFurnitureEntity.addComponent(decorationInventoryComponent);
        }
        this.constructionStore.remove(construction);
        this.messageDispatcher.dispatchMessage(325, createdFurnitureEntity);
        createdFurnitureEntity.getLocationComponent().setWorldPosition(VectorUtils.toVector(construction.getPrimaryLocation()), false);
        return true;
    }

    private Entity createAttachedItem(ItemType requiredItemType) {
        this.callbackItem = null;
        this.messageDispatcher.dispatchMessage(703, new ItemCreationRequestMessage(requiredItemType, item -> {
            this.callbackItem = item;
        }));
        return this.callbackItem;
    }

    private GameMaterial findApplicableMaterial(FurnitureConstruction construction, GameMaterialType gameMaterialType) {
        HashMap<GameMaterial, Integer> materialCounter = new HashMap<GameMaterial, Integer>();
        for (ItemAllocation itemAllocation : construction.getAllocatedItems()) {
            if (!itemAllocation.getGameMaterial().getMaterialType().equals((Object)gameMaterialType)) continue;
            Integer quantitySoFar = (Integer)materialCounter.get(itemAllocation.getGameMaterial());
            if (quantitySoFar == null) {
                quantitySoFar = 0;
            }
            quantitySoFar = quantitySoFar + itemAllocation.getQuantity();
            materialCounter.put(itemAllocation.getGameMaterial(), quantitySoFar);
        }
        int highestCount = 0;
        GameMaterial majorityMaterial = null;
        for (Map.Entry entry : materialCounter.entrySet()) {
            if ((Integer)entry.getValue() <= highestCount) continue;
            highestCount = (Integer)entry.getValue();
            majorityMaterial = (GameMaterial)entry.getKey();
        }
        return majorityMaterial;
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.gameContext = gameContext;
    }
}

